/*
 EPSHeader

   File: nextbuf.e
   Author: J. Kercheval
   Created: Sat, 10/21/1990  23:46:28
*/
/*
 EPSRevision History

   J. Kercheval  Sat, 10/22/1990  20:51:59  prevent switch to kill and tmp buffers
   J. Kercheval  Sat, 10/22/1990  21:29:45  add next_previous_buffer()
*/

/*

    This file implements two routines to add a quick single key switch from
    buffer to buffer.  next_buffer() here assigned to ALT-N (in keeping
    with the standard convention) and next_previous_buffer() assigned to 
    ALT-P.
        
    These two routines will not switch to one of the '-' prefixed buffers
    (ie. the kill buffers) and switches in a circular fashion.

        
        John Kercheval
        127 NW Bowdoin Pl #105
        Seattle, WA  98107-4960
        October 24, 1990
            
*/

#include "eel.h"

#define TRUE 1;
#define FALSE 0;

/*
* next_buffer() will make current window display the next buffer in the
* buffer list 10-22-90 JBK
*/
command next_buffer() on reg_tab[ALT('n')]
{
    char *cur_buf,*tmp_str[2];
    
    cur_buf = buffer_list(1);
    while (strcmp(bufname,cur_buf)) {
        cur_buf = buffer_list(0);
    }
    do {
        cur_buf = buffer_list(0);
        if (!cur_buf) cur_buf = buffer_list(1);
        strncpy(tmp_str,cur_buf,1);
    }
    while (!strcmp(tmp_str,"-"));
    to_buffer(cur_buf);
}
    
/*
* next_previous_buffer() will make current window display the previous
* buffer in the buffer list 10-22-90 JBK
*/
command next_previous_buffer() on reg_tab[ALT('p')]
{
    char *cur_buf,*last_buf[256],*tmp_str[2];
    int done;
    
    /*
    * obtain first last_buf
    */
    cur_buf = buffer_list(1);
    strcpy(last_buf,cur_buf);
    done = FALSE;
    do {
        cur_buf = buffer_list(0);
        if (!cur_buf) {
            cur_buf = buffer_list(1);
        }
        strncpy(tmp_str,last_buf,1);
        if (strcmp(tmp_str,"-")) {
            done = TRUE;
        }
        else {
            strcpy(last_buf,cur_buf);
        }
    }
    while (!done);
    
    /* 
    * find current buffer and maintain last_buf
    */
    done = FALSE;
    do {
        if (!strcmp(bufname,cur_buf)) {
            done = TRUE;
        }
        else {
            strncpy(tmp_str,cur_buf,1);
            if (strcmp(tmp_str,"-")) 
                strcpy(last_buf,cur_buf);
            cur_buf = buffer_list(0);
            if (!cur_buf) 
                cur_buf = buffer_list(1);
        }
    }
    while (!done);
    to_buffer(last_buf);
    
}
    